#include <internal/tab/repository.h>
#include <internal/service/conn_wrapper.h>
#include <pgg/database/fallback.h>

namespace macs {
namespace pg {

template<>
TabsRepositoryPtr createTabsRepository(
    pgg::fb::DatabaseGenerator dbg,
    const std::string& uid,
    pgg::query::RepositoryPtr repo,
    const pgg::RequestInfo& requestInfo,
    logging::v2::LogPtr logger)
{
    return std::make_shared<TabsRepository<pgg::fb::DatabaseGenerator>>(
        std::move(dbg), uid, repo, requestInfo, logger);
}

template<>
TabsRepositoryPtr createTabsRepository(
    ConnectionWrapper dbg,
    const std::string& uid,
    pgg::query::RepositoryPtr repo,
    const pgg::RequestInfo& requestInfo,
    logging::v2::LogPtr logger)
{
    return std::make_shared<TabsRepository<ConnectionWrapper>>(
        std::move(dbg), uid, repo, requestInfo, logger);
}

} // namespace pg
} // namespace macs
