#include <internal/thread/repository.h>
#include <internal/service/conn_wrapper.h>
#include <pgg/database/fallback.h>

namespace macs {
namespace pg {

template<>
ThreadsRepositoryPtr createThreadsRepository(
    pgg::fb::DatabaseGenerator dbg,
    LabelsRepositoryPtr labelsRepository,
    const std::string& uid,
    pgg::query::RepositoryPtr repo,
    const pgg::RequestInfo& requestInfo)
{
    return std::make_shared<ThreadsRepository<pgg::fb::DatabaseGenerator>>(
        std::move(dbg), labelsRepository, uid, repo, requestInfo);
}

template<>
ThreadsRepositoryPtr createThreadsRepository(
    ConnectionWrapper dbg,
    LabelsRepositoryPtr labelsRepository,
    const std::string& uid,
    pgg::query::RepositoryPtr repo,
    const pgg::RequestInfo& requestInfo)
{
    return std::make_shared<ThreadsRepository<ConnectionWrapper>>(
        std::move(dbg), labelsRepository, uid, repo, requestInfo);
}

} // namespace pg
} // namespace macs
