#include <internal/thread/threads_chooser.h>

#include <boost/range/algorithm/sort.hpp>
#include <algorithm>

namespace macs {
namespace pg {

const std::int32_t maxTotalThreadsSize = 2048;

TidVector chooseThreadsForJoin (ThreadInfoVec thrInfos) {
    if (thrInfos.empty()) {
        return TidVector();
    }

    using Ref = const ThreadInfo &;
    boost::sort( thrInfos, [] (Ref l, Ref r) { return l.msg_count > r.msg_count; } );

    if (thrInfos.front().msg_count >= maxTotalThreadsSize) {
        return TidVector{thrInfos.front().tid};
    }

    TidVector tids;
    std::int32_t total = 0;

    for (const auto & t : thrInfos) {
        if (total + t.msg_count < maxTotalThreadsSize) {
            total += t.msg_count;
            tids.push_back(t.tid);
        }
    }

    return tids;
}

} // namespace pg
} // namespace macs



