#include <internal/user/repository.h>
#include <internal/service/conn_wrapper.h>
#include <pgg/database/fallback.h>

namespace macs {
namespace pg {

template <>
UsersRepositoryPtr createUsersRepository(
    const pgg::fb::DatabaseGenerator& db,
    const std::string& uid,
    pgg::query::RepositoryPtr queryRepository,
    logging::v2::LogPtr logger,
    const pgg::RequestInfo& requestInfo)
{
    return std::make_shared<UsersRepository<pgg::fb::DatabaseGenerator>>(db, uid, queryRepository, logger, requestInfo);
}

template <>
UsersRepositoryPtr createUsersRepository(
    const ConnectionWrapper& db,
    const std::string& uid,
    pgg::query::RepositoryPtr queryRepository,
    logging::v2::LogPtr logger,
    const pgg::RequestInfo& requestInfo)
{
    return std::make_shared<UsersRepository<ConnectionWrapper>>(db, uid, queryRepository, logger, requestInfo);
}

}  // namespace pg
}  // namespace macs
