#include <service/get_macs_service.h>
#include <service/options.h>
#include "handlers_helper.h"

using namespace macs::pg::utils;

int main(int argc, char **argv) {
    std::string uid, dsn, lid;
    const auto err = parse(argc, argv).as(Uid(uid), Dsn(dsn), Lid(lid));
    if (err) {
        std::cerr << err.message() << std::endl;
        return -1;
    }
    const auto service = getMacsService(uid, dsn);

    std::cout << "Unmarks all messages with lid=" << lid << " for uid=" << uid << std::endl;

    try {
        Promise result;
        auto f = result.get_future();
        service->labels().clearLabel(lid, OnUpdateMessages(result));
        f.get();
    } catch (const std::exception& e) {
        std::cout << "exception: " << e.what() << std::endl;
    }

    return 0;
}
