#include <service/get_macs_service.h>
#include <service/formatter.h>
#include <service/options.h>

#include <boost/format.hpp>

using namespace macs::pg::utils;

int main(int argc, char **argv) {
    std::string dsn, uid, srcUid, authToken, rootFid, lid;

    const auto err = parse(argc, argv).as(Dsn(dsn), Uid(uid), SrcUid(srcUid),
        AuthToken(authToken), RootFolderId(rootFid), CollectorLabelId(lid));

    if (err) {
        std::cerr << err.message() << std::endl;
        return -1;
    }

    const auto service = getMacsService(uid, dsn);

    const auto formatStr = makeFormatStr({"revision", "collector_id"});

    try {
        macs::CollectorFactory factory;
        factory.srcUid(srcUid)
               .authToken(authToken)
               .rootFolderId(rootFid)
               .labelId(lid);
        auto res = service->collectors().createCollector(std::move(factory));
        std::cout << boost::format(formatStr)
                     % res.rev
                     % res.collector.collectorId();
        std::cout << "# Ok" << std::endl;
    } catch (const std::exception& e) {
        std::cerr << "# Exception: " << e.what() << std::endl;
    }

    std::cout << "# Complete" << std::endl;

    return 0;
}
