#include <service/get_macs_service.h>
#include <service/formatter.h>
#include <service/options.h>
#include <envelope_io.h>

#include <internal/collectors/state.h>

#include <boost/format.hpp>

using namespace macs::pg::utils;

int main(int argc, char **argv) {
    std::string dsn, uid, mid;
    int count;

    const auto err = parse(argc, argv).as(
        Dsn(dsn), Uid(uid), Mid(mid), Count(count));

    if (err) {
        std::cerr << err.message() << std::endl;
        return -1;
    }

    const auto service = getMacsService(uid, dsn);

    try {
        auto envelopes = service->collectors().getNextEnvelopeChunk(mid, count, macs::LabelSet());
        std::cout << "# Count: " << envelopes.size() << std::endl;
        EnvelopePrinter printer(std::cout);
        for (auto e: envelopes) {
            printer.print(e);
        }
        std::cout << "# Ok" << std::endl;
    } catch (const std::exception& e) {
        std::cerr << "# Exception: " << e.what() << std::endl;
    }

    std::cout << "# Complete" << std::endl;

    return 0;
}
