#include <service/get_macs_service.h>
#include <service/formatter.h>
#include <service/options.h>

#include <internal/collectors/state.h>

#include <boost/format.hpp>

using namespace macs::pg::utils;

int main(int argc, char **argv) {
    std::string dsn, shardId;
    std::vector<std::string> uids;

    const auto err = parse(argc, argv).as(
        Dsn(dsn), ShardId(shardId), Uids(uids));

    if (err) {
        std::cerr << err.message() << std::endl;
        return -1;
    }

    const auto shard = getShard(shardId, dsn);

    const auto formatStr = makeFormatStr({
        "uid", "collectorId", "srcUid", "authToken", "rootFolderId",
        "labelId", "ignoreFoldersStruct", "creationTs", "lastMid", "skippedMids",
        "state", "originalServer"});

    try {
        auto collectors = shard->collectors().getCollectors(uids);
        std::cout << "# Count: " << collectors.size() << std::endl;
        for (auto c: collectors) {
            auto skippedMids = std::string("[") + boost::join( c.skippedMids(), ", " ) + std::string("]");
            std::cout << boost::format(formatStr)
                         % c.uid()
                         % c.collectorId()
                         % c.srcUid()
                         % c.authToken()
                         % c.rootFolderId()
                         % c.labelId()
                         % c.ignoreFoldersStruct()
                         % c.creationTs()
                         % c.lastMid()
                         % skippedMids
                         % (macs::pg::CollectorState(c.state()).toString())
                         % c.originalServer();
        }
        std::cout << "# Ok" << std::endl;
    } catch (const std::exception& e) {
        std::cerr << "# Exception: " << e.what() << std::endl;
    }

    std::cout << "# Complete" << std::endl;

    return 0;
}
