#include <service/get_macs_service.h>
#include <service/formatter.h>
#include <service/options.h>

#include <boost/format.hpp>

using namespace macs::pg::utils;

int main(int argc, char **argv) {
    std::string dsn, shardId;

    const auto err = parse(argc, argv).as(Dsn(dsn), ShardId(shardId));

    if (err) {
        std::cerr << err.message() << std::endl;
        return -1;
    }

    const auto shard = getShard(shardId, dsn);

    const auto formatStr = makeFormatStr({
        "uid", "isHere", "isDeleted", "hereSinceTs", "purgeTs"});

    try {
        auto shardUsers = shard->collectors().getUsers();
        std::cout << "# Count: " << shardUsers.size() << std::endl;
        for (auto user: shardUsers) {
            std::cout << boost::format(formatStr)
                         % user.uid
                         % user.isHere
                         % user.isDeleted
                         % user.hereSinceTs
                         % user.purgeTs;
        }
        std::cout << "# Ok" << std::endl;
    } catch (const std::exception& e) {
        std::cerr << "# Exception: " << e.what() << std::endl;
    }

    std::cout << "# Complete" << std::endl;

    return 0;
}
