#include <service/get_macs_service.h>
#include <service/formatter.h>
#include <service/options.h>

#include <boost/format.hpp>

using namespace macs::pg::utils;

int main(int argc, char **argv) {
    std::string dsn, uid, authToken, rootFid, lid, mid;
    macs::CollectorId collectorId;
    std::time_t creationTs;

    const auto err = parse(argc, argv).as(Dsn(dsn), Uid(uid), CollectorId(collectorId),
        AuthToken(authToken), RootFolderId(rootFid), CollectorLabelId(lid), Mid(mid), CollectorCreationTs(creationTs));

    if (err) {
        std::cerr << err.message() << std::endl;
        return -1;
    }

    const auto service = getMacsService(uid, dsn);

    try {
        macs::CollectorFactory factory;
        factory.collectorId(collectorId)
               .authToken(authToken)
               .rootFolderId(rootFid)
               .labelId(lid)
               .lastMid(mid)
               .creationTs(creationTs);
        service->collectors().resetCollector(std::move(factory));
        std::cout << "# Ok" << std::endl;
    } catch (const std::exception& e) {
        std::cerr << "# Exception: " << e.what() << std::endl;
    }

    std::cout << "# Complete" << std::endl;

    return 0;
}
