#include <service/get_macs_service.h>
#include <service/formatter.h>
#include <service/options.h>

#include <boost/format.hpp>

using namespace macs::pg::utils;

int main(int argc, char **argv) {
    std::string dsn, uid, authToken, rootFid, lid;
    int32_t collectorId;

    const auto err = parse(argc, argv).as(Dsn(dsn), Uid(uid), CollectorId(collectorId),
        AuthToken(authToken), RootFolderId(rootFid), CollectorLabelId(lid));

    if (err) {
        std::cerr << err.message() << std::endl;
        return -1;
    }

    const auto service = getMacsService(uid, dsn);

    const auto formatStr = makeFormatStr({"revision"});

    try {
        macs::CollectorFactory factory;
        factory.collectorId(macs::CollectorId(collectorId))
            .authToken(authToken)
            .rootFolderId(rootFid)
            .labelId(lid);
        auto res = service->collectors().updateCollector(factory);
        std::cout << boost::format(formatStr) % res;
        std::cout << "# Ok" << std::endl;
    } catch (const std::exception& e) {
        std::cerr << "# Exception: " << e.what() << std::endl;
    }

    std::cout << "# Complete" << std::endl;

    return 0;
}
