#include <service/get_macs_service.h>
#include <service/formatter.h>
#include <service/options.h>

#include <boost/format.hpp>

using namespace macs::pg::utils;

int main(int argc, char **argv) {
    std::string dsn, uid, mid;
    int32_t collectorId;

    const auto err = parse(argc, argv).as(Dsn(dsn), Uid(uid),
        CollectorId(collectorId), Mid(mid));

    if (err) {
        std::cerr << err.message() << std::endl;
        return -1;
    }

    const auto service = getMacsService(uid, dsn);

    try {
        service->collectors().updateLastMid(macs::CollectorId(collectorId), mid);
        std::cout << "# Ok" << std::endl;
    } catch (const std::exception& e) {
        std::cerr << "# Exception: " << e.what() << std::endl;
    }

    std::cout << "# Complete" << std::endl;

    return 0;
}
