#include <service/get_macs_service.h>
#include <service/formatter.h>
#include <service/options.h>

#include <boost/format.hpp>

using namespace macs::pg::utils;

int main(int argc, char **argv) {
    std::string dsn, uid;
    int32_t collectorId;
    std::vector<std::string> skippedMids;

    const auto err = parse(argc, argv).as(Dsn(dsn), Uid(uid),
        CollectorId(collectorId), SkippedMids(skippedMids));

    if (err) {
        std::cerr << err.message() << std::endl;
        return -1;
    }

    const auto service = getMacsService(uid, dsn);

    try {
        service->collectors().updateSkippedMids(macs::CollectorId(collectorId), skippedMids);
        std::cout << "# Ok" << std::endl;
    } catch (const std::exception& e) {
        std::cerr << "# Exception: " << e.what() << std::endl;
    }

    std::cout << "# Complete" << std::endl;

    return 0;
}
