#include <service/get_macs_service.h>
#include <service/formatter.h>
#include <service/options.h>

#include <internal/collectors/state.h>

#include <boost/format.hpp>

using namespace macs::pg::utils;

int main(int argc, char **argv) {
    std::string dsn, uid, state;
    int32_t collectorId;

    const auto err = parse(argc, argv).as(Dsn(dsn), Uid(uid),
        CollectorId(collectorId), CollectorState(state));

    if (err) {
        std::cerr << err.message() << std::endl;
        return -1;
    }

    const auto service = getMacsService(uid, dsn);

    const auto formatStr = makeFormatStr({"revision"});

    try {
        auto res = service->collectors().updateState(
            macs::CollectorId(collectorId), macs::pg::CollectorState::fromString(state));
        std::cout << boost::format(formatStr) % res;
        std::cout << "# Ok" << std::endl;
    } catch (const std::exception& e) {
        std::cerr << "# Exception: " << e.what() << std::endl;
    }

    std::cout << "# Complete" << std::endl;

    return 0;
}
