#include <future>

#include <boost/algorithm/string/join.hpp>

#include "service/get_macs_service.h"
#include "service/options.h"

using namespace macs::pg::utils;

int main(int argc, char **argv) {
    using boost::algorithm::join;

    std::string uid, dsn, fid;
    std::vector<std::string> mids;

    const auto err = parse(argc, argv).as(Uid(uid), Dsn(dsn),
                                          Mids(mids), Fid(fid));
    if (err) {
        std::cerr << err.message() << std::endl;
        return -1;
    }

    const auto service = getMacsService(uid, dsn);

    std::cout << "# Copy messages " << join(mids, ", ") << " to fid=" << fid
              << " for uid=" << uid << std::endl;

    std::promise<void> copyResult;
    auto f = copyResult.get_future();

    const auto handle = [&] (macs::error_code ec, auto res) {
        auto p = std::move(copyResult);
        if (ec) {
            mail_errors::setRuntimeError(p, ec);
        } else {
            std::cout << "- Revision: " << res.rev << std::endl;
            if (res.mids.size() == 1) {
                std::cout << "  Mid: " << res.mids.front() << std::endl;
            } else if (res.mids.size() > 1) {
                std::cout << "  Mids: [" << join(res.mids, ", ") << "]" << std::endl;
            } else {
                std::cout << "# No new messages";
            }
            p.set_value();
        }
    };
    try {
        service->envelopes().copyMessages(fid, mids, handle);

        f.get();
    } catch( const std::exception & e ) {
        std::cerr << e.what() << std::endl;
    }
    return 0;
}
