#include "service/get_macs_service.h"
#include "service/options.h"

#include <macs/folder.h>
#include <boost/algorithm/string/classification.hpp>
#include <boost/algorithm/string/split.hpp>

using namespace macs::pg::utils;

int main(int argc, char **argv) {
    std::string uid, dsn, path;

    const auto err = parse(argc, argv).as(Uid(uid), Dsn(dsn), FolderPath(path));

    if (err) {
        std::cerr << err.message() << std::endl;
        return -1;
    }

    const auto service = getMacsService(uid, dsn);
    std::vector<std::string> names;
    boost::algorithm::split(names, path, boost::algorithm::is_any_of("|"));

    std::cout << "# Create folder with path=\"" << path << "\" for user with uid=" << uid << std::endl;

    try {
        const auto result = service->folders().createFolderByPath(macs::Folder::Path(names));
        std::cout << "- Revision: " << result.revision() << std::endl
                  << "  Fid: " << result.fid() << std::endl;
    } catch (const std::exception& e) {
        std::cerr << e.what() << std::endl;
        return -1;
    }

    return 0;
}
