#include <future>

#include "service/get_macs_service.h"
#include "service/options.h"

#include <macs/folder.h>
#include <macs_pg/mailish/folder_info_factory.h>

using namespace macs::pg::utils;

int main(int argc, char **argv) {
    std::string uid, dsn, name, parent;

    const auto err = parse(argc, argv).as(Uid(uid), Dsn(dsn),
                                          FolderName(name),
                                          ParentFid(parent).def(macs::Folder::noParent));

    if (err) {
        std::cerr << err.message() << std::endl;
        return -1;
    }

    const auto service = getMacsService(uid, dsn);

    std::cout << "# Create folder with name=\"" << name << "\"";

    if (!parent.empty()) {
        std::cout << " in folder with fid=" << parent;
    }

    std::cout << " for user with uid=" << uid << std::endl;

    try {
        auto folder = service->folders().createFolder(name, parent);
        std::cout << "- Revision: " << folder.revision() << std::endl
                  << "  Fid: " << folder.fid() << std::endl;
        macs::MailishFolderInfoFactory factory;
        factory
            .externalPath(name)
            .uidValidity(123);
        service->mailish().initFolder(folder.fid(), factory.release());
    } catch (const std::exception& e) {
        std::cerr << e.what() << std::endl;
    }

    return 0;
}
