#include <service/get_macs_service.h>
#include <service/options.h>
#include "handlers_helper.h"

using namespace macs::pg::utils;

int main(int argc, char **argv) {
    std::string uid, dsn, symbolTitle;
    const auto err = parse(argc, argv).as(Uid(uid), Dsn(dsn),
            String(symbolTitle, "symbol", "create system label with given symbol"));
    if (err) {
        std::cerr << err.message() << std::endl;
        return -1;
    }

    const auto & symbol = macs::Label::Symbol::getByTitle(symbolTitle);
    const auto service = getMacsService(uid, dsn);

    std::cout << "# Create label with symbol = " << symbolTitle
            << " for user with uid=" << uid << std::endl;

    try {
        Promise result;
        auto f = result.get_future();
        service->labels().createLabel(symbol, OnUpdateLabel(result));
        f.get();
    } catch (const std::exception& e) {
        std::cerr << e.what() << std::endl;
    }

    return 0;
}
