#include <boost/program_options.hpp>
#include <boost/lexical_cast.hpp>
#include <macs_pg/macs_pg.h>

#include <service/get_macs_service.h>
#include <service/options.h>
#include "handlers_helper.h"

using namespace macs::pg::utils;

int main(int argc, char **argv) {
    std::string uid, dsn, fid;
    bool forced;
    const auto err = parse(argc, argv).as(Uid(uid), Dsn(dsn),
                                          Fid(fid), Forced(forced));
    if (err) {
        std::cerr << err.message() << std::endl;
        return -1;
    }

    const auto service = getMacsService(uid, dsn);

    auto folder = service->folders().getFolderByFid(fid);

    std::cout << "# Get folder with fid= " << fid
              << " for uid=" << uid << std::endl;

    try {
        hooks::Promise result;
        auto f = result.get_future();
        if (forced) {
            std::cout << "# Call eraseCascade" << std::endl;
            service->folders().eraseCascade(folder, hooks::OnUpdate(result));
        } else {
            std::cout << "# Call erase" << std::endl;
            service->folders().erase(folder, hooks::OnUpdate(result));
        }
        f.get();
    } catch ( const std::exception & e ) {
        std::cerr << e.what() << std::endl;
        return -1;
    }

    return 0;
}
