#include <service/get_macs_service.h>
#include <service/options.h>
#include "handlers_helper.h"

using namespace macs::pg::utils;

int main(int argc, char **argv) {
    std::string uid, dsn, stid;
    const auto err = parse(argc, argv).as(Uid(uid), Dsn(dsn), Stid(stid));
    if (err) {
        std::cerr << err.message() << std::endl;
        return -1;
    }

    try {
        const auto service = getMacsService(uid, dsn);
        std::cout << "Delete from storage stid=" << stid
                  << " for user with uid=" << uid << std::endl;

        hooks::Promise result;
        auto f = result.get_future();
        service->envelopes().deleteFromStorage(stid, hooks::OnExecute(result));
        f.get();
    } catch (const std::exception& e) {
        std::cerr << "Exception: " << e.what() << std::endl;
    }

    return 0;
}
