#ifndef MACS_PG_ENVELOPE_PRINT_SCOPE_H_152910012015
#define MACS_PG_ENVELOPE_PRINT_SCOPE_H_152910012015

#include <macs/detail/bitmask.h>

//! print fields mask
namespace macs {
namespace pg {
namespace utils {
namespace internal {

enum PrintScope {
    ePrintNone            = 0,
    ePrintMid             = MACS_BIT2 ( 1 ),
    ePrintFid             = MACS_BIT2 ( 2 ),
    ePrintTid             = MACS_BIT2 ( 3 ),
    ePrintFrom            = MACS_BIT2 ( 4 ),
    ePrintTo              = MACS_BIT2 ( 5 ),
    ePrintCc              = MACS_BIT2 ( 6 ),
    ePrintReplyTo         = MACS_BIT2 ( 7 ),
    ePrintSubject         = MACS_BIT2 ( 8 ),
    ePrintTypes           = MACS_BIT2 ( 9 ),
    ePrintLabels          = MACS_BIT2 ( 10 ),
    ePrintSeen            = MACS_BIT2 ( 11 ),
    ePrintHasAttaches     = MACS_BIT2 ( 12 ),
    ePrintThreadCount     = MACS_BIT2 ( 13 ),
    ePrintThreadNewCount  = MACS_BIT2 ( 14 ),
    ePrintReceiveDate     = MACS_BIT2 ( 15 ),
    ePrintSentDate        = MACS_BIT2 ( 16 ),
    ePrintRevision        = MACS_BIT2 ( 17 ),
    ePrintLast
};

} // namespace internal

typedef macs::detail::bitmask<internal::PrintScope, internal::ePrintLast> EnvelopePrintScope;

const EnvelopePrintScope envelopePrintNone ( internal::ePrintNone);

const EnvelopePrintScope envelopePrintMid ( internal::ePrintMid);
const EnvelopePrintScope envelopePrintFid ( internal::ePrintFid );
const EnvelopePrintScope envelopePrintTid ( internal::ePrintTid );
const EnvelopePrintScope envelopePrintRevision ( internal::ePrintRevision );
const EnvelopePrintScope envelopePrintFrom ( internal::ePrintFrom );
const EnvelopePrintScope envelopePrintTo ( internal::ePrintTo );
const EnvelopePrintScope envelopePrintCc ( internal::ePrintCc );
const EnvelopePrintScope envelopePrintReplyTo ( internal::ePrintReplyTo );
const EnvelopePrintScope envelopePrintSubject ( internal::ePrintSubject );
const EnvelopePrintScope envelopePrintTypes ( internal::ePrintTypes );
const EnvelopePrintScope envelopePrintLabels ( internal::ePrintLabels );
const EnvelopePrintScope envelopePrintSeen ( internal::ePrintSeen );
const EnvelopePrintScope envelopePrintHasAttaches ( internal::ePrintHasAttaches );
const EnvelopePrintScope envelopePrintThreadCount ( internal::ePrintThreadCount );
const EnvelopePrintScope envelopePrintThreadNewCount ( internal::ePrintThreadNewCount );
const EnvelopePrintScope envelopePrintReceiveDate ( internal::ePrintReceiveDate );
const EnvelopePrintScope envelopePrintSentDate ( internal::ePrintSentDate );

const EnvelopePrintScope envelopePrintKeys (envelopePrintMid | envelopePrintFid | envelopePrintTid | envelopePrintRevision);
const EnvelopePrintScope envelopePrintBase (envelopePrintKeys | envelopePrintFrom | envelopePrintTo | envelopePrintSubject);
const EnvelopePrintScope envelopePrintRecipients (envelopePrintFrom | envelopePrintTo | envelopePrintCc | envelopePrintReplyTo);
const EnvelopePrintScope envelopePrintAllMailInfo (envelopePrintBase | envelopePrintRecipients |
        envelopePrintTypes | envelopePrintLabels | envelopePrintSeen | envelopePrintHasAttaches |
        envelopePrintThreadCount | envelopePrintThreadNewCount |
        envelopePrintReceiveDate | envelopePrintSentDate);

} // namespace macs
} // namespace pg
} // utils

#endif // MACS_PG_ENVELOPE_PRINT_SCOPE_H_152910012015
