#ifndef MACS_PG_UTILS_ENVELOPE_STATUS_H_2015_08_27
#define MACS_PG_UTILS_ENVELOPE_STATUS_H_2015_08_27

#include <map>
#include <macs/envelope.h>

namespace macs {
namespace pg {
namespace utils {

typedef std::map<std::string, Envelope::Status> StatusMap;
static const StatusMap statusMap = {
    {"read", macs::Envelope::Status_read},
    {"unread", macs::Envelope::Status_unread},
    {"replied", macs::Envelope::Status_replied},
    {"forwarded", macs::Envelope::Status_forwarded}
};

inline std::string getPossibleStatuses() {
    std::vector<std::string> keys;
    for (const auto& kv: statusMap) {
        keys.push_back(kv.first);
    }
    return boost::algorithm::join(keys, ",");
}


inline Envelope::Status getStatus(const std::string& s) {
    const auto i = statusMap.find(s);
    if (i == statusMap.end()) {
        throw std::invalid_argument("unsupported status " + s + ", possible values: " + getPossibleStatuses());
    }
    return i->second;
}

} // namespace utils
} // namespace pg
} // namespace macs

#endif // MACS_PG_UTILS_ENVELOPE_STATUS_H_2015_08_27
