#ifndef MACS_PG_ENVELOPES_QUERY_HELPER_H_141410012015
#define MACS_PG_ENVELOPES_QUERY_HELPER_H_141410012015

#include "envelope_io.h"
#include "service/get_macs_service.h"

namespace macs {
namespace pg {
namespace utils {

const int defaultFrom = 0;
const std::size_t defaultCount = 10;

macs::Label getLabel (const std::string & lid) {
    return macs::LabelFactory().lid(lid);
}

class OnEnvelope {
public:
    OnEnvelope(std::vector<macs::Envelope> & envelopes, const EnvelopePrintScope & scope)
        : envelopes(envelopes), printScope(scope) {}

    void operator()(macs::error_code err, auto e) const {
        if( err ) {
            std::cerr << err.message() << std::endl;
        } else {
            for (const auto& v : e) {
                EnvelopePrinter(std::cout, printScope).print(v);
                envelopes.push_back(v);
            }
        }
    }

private:
    std::vector<macs::Envelope> & envelopes;
    EnvelopePrintScope printScope;
};


inline void executeQuery (const std::string queryDescription, macs::EnvelopesQuery& query,
        EnvelopePrintScope scope = envelopePrintAllMailInfo) {
    std::vector<macs::Envelope> envelopes;

    std::cout << "# Begin request " << queryDescription << std::endl;
    std::cout << "# ===============================================" << std::endl;

    OnEnvelope handler(envelopes, scope);

    macs::error_code ec;
    auto value = query.get(macs::io::use_sync[ec]);
    handler(ec, std::move(value));

    std::cout << "# Total count fetched: " << envelopes.size() << std::endl;
}

} // namespace macs
} // namespace pg
} // utils

#endif /* MACS_PG_ENVELOPES_QUERY_HELPER_H_141410012015 */
