#include <iostream>

#include "service/params.h"
#include "service/options.h"
#include "service/get_macs_service.h"

using namespace macs::pg::utils;

int main(int argc, char **argv) {
    std::string dsn;
    std::string launchId;

    const auto err = parse(argc, argv).as(Dsn(dsn),
                                          LaunchId(launchId));

    if (err) {
        std::cerr << err.message() << std::endl;
        return -1;
    }

    const auto service = getShard("42", dsn);
    macs::error_code ec;

    std::cout << "# FindAJob with " << launchId << " launch" << std::endl;

    auto foundJob = service->subscriptions().findAJob(
        std::chrono::seconds(10),
        launchId,
        "test-hostname",
        "some-version"
    );
    if (foundJob) {
        std::cout << "# We got a job" << std::endl
                  << "WorkerId: " << *foundJob << std::endl
                  << "# Now try confirm it" << std::endl;
        auto confirmed = service->subscriptions().confirmTheJob(*foundJob, launchId);
        std::cout << "Confirmed: " << (confirmed ? "yes": "no") << std::endl;
    } else {
        std::cout << "# Dobby is free!!!" << std::endl;
    }

    return 0;
}
