#include "macs_pg/macs_pg.h"
#include <iostream>
#include <boost/system/error_code.hpp>
#include "service/get_macs_service.h"
#include "service/options.h"

using namespace macs::pg;
using namespace macs::pg::utils;

int main(int argc, char** argv)
{
    std::string uid, dsn;

    const auto err = parse(argc, argv).as(Uid(uid), Dsn(dsn));
    if (err) {
        std::cerr << err.message() << std::endl;
        return -1;
    }

    try {
        const auto service = getMacsService(uid, dsn);
        auto fids = service->sharedFolders().getAllSharedFolders();

        std::cout << "Shared folders for user " << uid
                  << ": {" << boost::algorithm::join(fids, ",")
                  << "} (total: " << fids.size() << ")" << std::endl;

    } catch (const std::exception& e) {
        std::cerr << e.what() << std::endl;
    }

    return 0;
}

