#include <macs/errors.h>
#include <macs_pg/macs_pg.h>
#include <iostream>
#include <string>
#include <boost/algorithm/string/join.hpp>
#include "service/get_macs_service.h"
#include "service/options.h"
#include "envelope_io.h"

using namespace macs::pg::utils;

int main(int argc, char** argv) {
    std::string uid, dsn;
    std::vector<std::string> mids;

    const auto err = parse(argc, argv).as(Uid(uid), Dsn(dsn), Mids(mids));

    if (err) {
        std::cerr << err.message() << std::endl;
        return -1;
    }

    const auto service = getMacsService(uid, dsn);
    std::promise<void> result;
    auto f = result.get_future();
    using boost::algorithm::join;

    std::cout << "Get envelopse by ids request for UID=" << uid
              << " and MIDS={" << join(mids, ",") << "}" << std::endl;

    const auto handler = [&](macs::error_code err, auto envelope) {
        auto p = std::move(result);
        if (err) {
            mail_errors::setRuntimeError(p, err);
        } else if(envelope) {
            EnvelopePrinter(std::cout).print(envelope.get());
        } else {
            p.set_value();
        }
    };

    try {
        service->envelopes().getByIds(std::list<std::string>(mids.begin(), mids.end()), handler);
        f.get();
    } catch (const std::exception& e) {
        std::cerr << e.what() << std::endl;
    }

    return 0;
}
