#include <macs_pg/macs_pg.h>
#include <iostream>
#include <string>
#include "service/get_macs_service.h"
#include "service/options.h"

using namespace macs::pg::utils;

int main(int argc, char** argv) {
    std::string uid, dsn, fid;
    std::time_t dateFrom, dateTo;

    const auto err = parse(argc, argv).as(Uid(uid), Dsn(dsn), Fid(fid),
                                    DateFrom(dateFrom), DateTo(dateTo));

    if (err) {
        std::cerr << err.message() << std::endl;
        return -1;
    }

    const auto service = getMacsService(uid, dsn);

    std::cout << "****** EnvelopesCount request for UID=" << uid << " and FID=" << fid << std::endl;

    const auto handler = [fid](const macs::error_code& err, std::size_t size) {
        if (err) {
            std::cerr << "Error: " << err << std::endl;
        } else {
            std::cout << "Fid: " << fid << ", envelopes count: " << size << std::endl;
        }
    };

    macs::error_code ec;
    const auto size = service->envelopes().getEnvelopesCount(fid, dateFrom, dateTo, macs::io::use_sync[ec]);
    handler(ec, size);

    return 0;
}
