#include "macs_pg/macs_pg.h"
#include <iostream>
#include <boost/system/error_code.hpp>
#include "service/get_macs_service.h"
#include "service/options.h"

void printDate(const macs::error_code& code, std::time_t value)
{
    std::cout << "Get value: \'" << value << "\', code == " << code << std::endl;
}

using namespace macs::pg;
using namespace macs::pg::utils;

int main(int argc, char** argv)
{
    std::string uid, dsn, fid;

    const auto err = parse(argc, argv).as(Uid(uid), Dsn(dsn), Fid(fid));
    if (err) {
        std::cerr << err.message() << std::endl;
        return -1;
    }

    macs::ServicePtr service = utils::getMacsService(uid, dsn);

    macs::error_code ec;
    const auto time = service->envelopes().getFirstEnvelopeDate(fid, macs::io::use_sync[ec]);
    printDate(ec, time);

    return 0;
}
