#include <iostream>

#include "service/params.h"
#include "service/options.h"
#include "service/get_macs_service.h"
#include "subscription_io.h"

using namespace macs::pg::utils;


int main(int argc, char **argv) {
    std::string dsn;
    std::string workerId;
    std::size_t limit;

    const auto err = parse(argc, argv).as(Dsn(dsn), WorkerId(workerId),
                                          SubscriptionsLimit(limit));

    if (err) {
        std::cerr << err.message() << std::endl;
        return -1;
    }

    const auto service = getShard("42", dsn);
    macs::error_code ec;

    std::cout << "# Get " << limit << " free subscriptions for worker: " << workerId << std::endl;
    OnSubscriptionsChunk handler;
    auto data = service->subscriptions().getFreeForWorker(workerId, limit, macs::io::use_sync[ec]);
    handler(ec, data);

    return 0;
}