#include <macs_pg/macs_pg.h>
#include "service/get_macs_service.h"
#include "service/options.h"
#include "handlers_helper.h"

using namespace macs::pg::utils;

int main(int argc, char **argv) {
    std::string uid, dsn;

    const auto err = parse(argc, argv).as(Uid(uid), Dsn(dsn));
    if (err) {
        std::cerr << err.message() << std::endl;
        return -1;
    }

    try {
        macs::ServicePtr service = getMacsService(uid, dsn);
        std::cout << "Reset fresh counter for UID=" << uid << std::endl;
        Promise result;
        auto f = result.get_future();
        service->envelopes().resetFreshCounter(OnUpdate(result));
        f.get();
        std::cout << "Success" << std::endl;
    } catch (const std::runtime_error& e) {
        std::cerr << "Exception: " << e.what() << std::endl;
    }

    return 0;
}
