#include <iostream>
#include <boost/algorithm/string/join.hpp>
#include <boost/range/adaptor/transformed.hpp>

#include "service/params.h"
#include "service/options.h"
#include "service/get_macs_service.h"


using namespace macs::pg::utils;

namespace {

    std::ostream& operator << ( std::ostream& s,  const macs::ChangeIdChunk& changeIds ) {
        s << "[" << boost::join(
            changeIds | boost::adaptors::transformed(
                [](auto v){return std::to_string(v);}), "," ) << "]";
        return s;
    }
}

int main(int argc, char **argv) {
    std::string dsn;
    std::string uid;
    std::int64_t subscriptionId = 0;
    int count = 20;

    const auto err = parse(argc, argv).as(Dsn(dsn), Uid(uid),
                                          SubscriptionId(subscriptionId),
                                          Count(count));
    if (err) {
        std::cerr << err.message() << std::endl;
        return -1;
    }
    const auto service = getShard("42", dsn);

    std::cout << "# GetFromChangeQueue " << std::endl;

    const auto handler = [](const macs::error_code& ec, auto cids) {
        if (ec) {
            std::cerr << "Error:" << ec.what() << std::endl;
        }
        else {
            std::cout << cids << std::endl;
        }
    };

    macs::error_code ec;
    auto cids = service->changeQueue().get(uid, subscriptionId, count, macs::io::use_sync[ec]);
    handler(ec, std::move(cids));

    return 0;
}