#include <future>

#include "service/get_macs_service.h"
#include "service/options.h"

#include <macs_pg/mailish/repository.h>
#include <internal/mailish/auth_type.h>

using namespace macs::pg::utils;

std::string toString(const macs::MailishAuthData& data) {
    std::stringstream str;
    str
        << " # AuthData: "
        << " token_id=" << data.tokenId()
        << " auth_type=" << macs::pg::AuthType(data.authType()).toString()
        << " uuid=" << data.uuid()
        << " oauth_app=" << data.oauthApplication()
        << " imap_credentials=" << data.imapCredentials()
        << " smtp_credentials=" << data.smtpCredentials();

    return str.str();
}

std::string toString(const macs::MailishAccount& account) {
    std::stringstream str;
    str
        << " # Account: "
        << " email=" << account.email()
        << " imap_login=" << account.imapLogin()
        << " imap_ssl=" << account.imapSsl()
        << " imap_server=" << account.imapServer()
        << " imap_port=" << account.imapPort()
        << " smtp_login=" << account.smtpLogin()
        << " smtp_ssl=" << account.smtpSsl()
        << " smtp_server=" << account.smtpServer()
        << " smtp_port=" << account.smtpPort();
    return str.str();
}

int main(int argc, char **argv) {
    std::string uid, dsn;

    const auto err = parse(argc, argv).as(Uid(uid), Dsn(dsn));

    if (err) {
        std::cerr << err.message() << std::endl;
        return -1;
    }

    const auto service = getMacsService(uid, dsn);

    std::cout << "# Get mailish auth data" << std::endl;

    try {
        auto dataChunk = service->mailish().getAuthData();
        std::cout << "# Count: " << dataChunk.size() << std::endl;
        for (auto data: dataChunk) {
            std::cout << toString(data) << std::endl;
        }
        auto account = service->mailish().getAccount();
        std::cout << toString(account) << std::endl;
        std::cout << "# Ok" << std::endl;
    } catch (const std::exception& e) {
        std::cerr << "# Exception: " << e.what() << std::endl;
    }

    std::cout << "# Complete" << std::endl;

    return 0;
}
