#include "handlers_helper.h"
#include "service/get_macs_service.h"
#include "service/options.h"

using namespace macs::pg::utils;

namespace {

void printAttach (const macs::AttachmentDescriptor& attach) {
    std::cout << "- hid: " << attach.m_hid
            << "\n  contentType: " << attach.m_contentType
            << "\n  fileName: " << attach.m_fileName
            << "\n  size: " << attach.m_size << std::endl;
}

}

int main(int argc, char **argv) {
    std::string uid, dsn, mid;
    const auto err = parse(argc, argv).as(Uid(uid), Dsn(dsn), Mid(mid));
    if (err) {
        std::cerr << err.message() << std::endl;
        return -1;
    }

    const auto service = getMacsService(uid, dsn);
    std::cout << "# Get message attachments for mid=" << mid << " for uid=" << uid << std::endl;

    try {
        std::promise<void> result;
        auto resFuture = result.get_future();
        const auto hook = [&result] (const macs::error_code& ec, const macs::Attachments& attaches) {
            auto p = std::move(result);
            if (ec) {
                mail_errors::setRuntimeError(p, ec);
            } else {
                for (const auto& attach: attaches) {
                    printAttach(attach);
                }
                p.set_value();
            }
        };

        service->envelopes().getAttachments(mid, hook);

        resFuture.get();
    } catch (const std::exception& e) {
        std::cerr << e.what() << std::endl;
    }

    return 0;
}

