#include "macs_pg/macs_pg.h"
#include <iostream>
#include <boost/system/error_code.hpp>
#include "service/get_macs_service.h"
#include "service/options.h"

using namespace macs::pg;
using namespace macs::pg::utils;

int main(int argc, char** argv)
{
    std::string dsn;

    const auto err = parse(argc, argv).as(Dsn(dsn));
    if (err) {
        std::cerr << err.message() << std::endl;
        return -1;
    }

    try {
        macs::ShardPtr shard = utils::getShard("42", dsn);
        macs::ChangeId cid = shard->changeLog().getMinimumKnownChangeId();

        std::cout << "Minimum change_id: " << cid << std::endl;
    } catch (const std::exception& e) {
        std::cerr << e.what() << std::endl;
    }

    return 0;
}
