#include <service/get_macs_service.h>
#include <service/options.h>
#include "handlers_helper.h"

using namespace macs::pg::utils;

int main(int argc, char **argv) {
    std::string uid, dsn, color, name, type, symbol;
    const auto err = parse(argc, argv).as(Uid(uid), Dsn(dsn),
                                          String(symbol, "symbol", "create label with given symbolic name").notNecessarily(),
                                          String(name, "name", "create label with given name").notNecessarily(),
                                          String(color, "color", "label color").notNecessarily(),
                                          String(type, "type", "label type").notNecessarily().def("user"));
    if (err) {
        std::cerr << err.message() << std::endl;
        return -1;
    }

    const auto service = getMacsService(uid, dsn);

    try {
        macs::Label lblFirst, lblSecond;
        if (symbol.empty()) {
            std::cout << "# Create label with name = " << name
                    << ", color=" << color << ", type = " << type
                    << " for user with uid=" << uid << std::endl;

            const auto lType = macs::Label::Type::getByTitle(type);
            lblFirst = service->labels().getOrCreateLabel(name, color, lType);
            lblSecond = service->labels().getOrCreateLabel(name, color, lType);
        } else {
            std::cout << "# Create label with symbolic name = " << symbol
                    << " for user with uid=" << uid << std::endl;

            const auto lSymbol = macs::Label::Symbol::getByTitle(symbol);
            lblFirst = service->labels().getOrCreateLabel(lSymbol);
            lblSecond = service->labels().getOrCreateLabel(lSymbol);
        }

        std::cout << "# First label ID: " << lblFirst.lid()
                  << ", Second label ID: " << lblSecond.lid()
                  << std::endl;
        if (lblFirst.lid() != lblSecond.lid())
            throw std::runtime_error("Different values of labels' ID (expected equal)");

    } catch (const std::exception& e) {
        std::cerr << e.what() << std::endl;
    }

    return 0;
}
