#include "macs_pg/macs_pg.h"
#include <iostream>
#include <boost/system/error_code.hpp>
#include "service/get_macs_service.h"
#include "service/options.h"

using namespace macs::pg;
using namespace macs::pg::utils;

int main(int argc, char** argv)
{
    std::string uid, ownerUid, dsn;

    const auto err = parse(argc, argv).as(Uid(uid), OwnerUid(ownerUid), Dsn(dsn));
    if (err) {
        std::cerr << err.message() << std::endl;
        return -1;
    }

    try {
        const auto service = getMacsService(uid, dsn);
        auto folders = service->subscribedFolders().getFoldersByOwner(ownerUid);

        std::cout << "Subscribed Folders for user " << uid
                  << " and owner " << ownerUid << ":" << std::endl;
        for (const macs::SubscribedFolder& f: folders) {
            std::cout << "Subscribed folder:"
                      << "\n fid: " << f.fid()
                      << "\n owner_uid: " << f.ownerUid()
                      << "\n owner_fid: " << f.ownerFid()
                      << "\n synced_revision: " << f.syncedRevision()
                      << "\n revision: " << f.revision()
                      << "\n created: " << f.created()
                      << std::endl;
        }
    } catch (const std::exception& e) {
        std::cerr << e.what() << std::endl;
    }

    return 0;
}
