#include "service/get_macs_service.h"
#include "service/options.h"

using namespace macs::pg::utils;

int main(int argc, char** argv) {
    std::string uid, dsn, ownerUid, ownerFid;

    const auto parseResult = parse(argc, argv).as(
        Uid(uid), Dsn(dsn), OwnerUid(ownerUid), OwnerFid(ownerFid)
    );

    if (parseResult) {
        std::cerr << parseResult.message() << std::endl;
        return -1;
    }

    std::cout << "# Get synced revision for uid=" << uid
              << " with ownerUid=" << ownerUid
              << " with ownerFid=" << ownerFid << std::endl;

    try {
        const auto service = getMacsService(uid, dsn);
        const auto result = service->subscribedFolders().getSyncedRevision(ownerUid, ownerFid);
        if (!result) {
            std::cerr << "Synced revision not found" << std::endl;
            return -1;
        }
        std::cout << "Synced revision=" << result.get().value() << std::endl;
    } catch (const std::exception& e) {
        std::cerr << "exception: " << e.what() << std::endl;
        return -1;
    }

    return 0;
}
