#ifndef MACS_PG_HANDLERS_HELPER_H_141430032015
#define MACS_PG_HANDLERS_HELPER_H_141430032015

#include <macs/hooks.h>
#include <mail_errors/set_exception.h>
#include <future>

namespace macs {
namespace pg {
namespace utils {
namespace hooks {

using Promise = std::promise<void>;

inline void printResult() {
    std::cout << "Success: true" << std::endl;
}

struct OnExecute {
    Promise & result;
    OnExecute(Promise & result) : result(result) {}
    void operator()(macs::error_code ec) const {
        auto p = std::move(result);
        if (ec) {
            mail_errors::setRuntimeError(p, ec);
        } else {
            printResult();
            p.set_value();
        }
    }
};

inline void printResult(const Revision& revision) {
    std::cout << "Revision: " << revision << std::endl;
}

struct OnUpdate {
    Promise & result;
    OnUpdate(Promise & result) : result(result) {}
    void operator()(macs::error_code ec, macs::Revision revision) const {
        auto p = std::move(result);
        if (ec) {
            mail_errors::setRuntimeError(p, ec);
        } else {
            printResult(revision);
            p.set_value();
        }
    }
};

inline void printResult(const UpdateMessagesResult& res) {
    std::cout << "- Revision: " << res.rev << std::endl;
    std::cout << "  MessagesUpdated: " << res.affected << std::endl;
}

struct OnUpdateMessages {
    Promise & result;
    OnUpdateMessages(Promise & result) : result(result) {}
    void operator()(macs::error_code ec, auto res) const {
        auto p = std::move(result);
        if (ec) {
            mail_errors::setRuntimeError(p, ec);
        } else {
            printResult(res);
            p.set_value();
        }
    }
};

inline void printResult(const Label& l) {
    std::cout << "- Lid:  " << l.lid() << std::endl;
    std::cout << "  Name:  " << l.name() << std::endl;
    std::cout << "  Revision: " << l.revision() << std::endl;
    std::cout << "  Color: " << l.color() << std::endl;
    std::cout << "  Type: " << l.type().title() << std::endl;
    std::cout << "  Symbol: " << l.symbolicName().title() << std::endl;
    std::cout << "  Messages: " << l.messagesCount() << std::endl;
}

struct OnUpdateLabel {
    Promise & result;
    OnUpdateLabel(Promise & result) : result(result) {}
    void operator() (macs::error_code ec, Label l) const {
        auto p = std::move(result);
        if (ec) {
            mail_errors::setRuntimeError(p, ec);
        } else {
            std::cout << "# Label updated. New state is: " << std::endl;
            printResult(l);
            p.set_value();
        }
    }
};


} // namespace hooks

using namespace hooks;
} // namespace utils
} // namespace pg
} // namespace macs

#endif /* MACS_PG_HANDLERS_HELPER_H_141430032015 */
