# coding: utf-8

# ARCH PYTHONPATH modifications
import os.path
import sys
from argparse import ArgumentParser
import logging

log = logging.getLogger(__name__)

def hook_py_path():
    mdb_api_path = os.path.join(
        os.path.dirname(__file__),
        '../../mdb'
    )
    sys.path.append(mdb_api_path)

hook_py_path()

from pymdb.tools import cleanup
from pymdb.connect import Connector
from pymdb.vegetarian import fill_data

def init_user(conn, uid):
    cleanup(conn, uid)
    fill_data(conn, uid)

def main():
    parser = ArgumentParser(
        description='initialize data for utils check',
    )
    parser.add_argument(
        '--dsn',
        metavar='PG_DSN',
        type=str,
        default='maildb'
    )
    parser.add_argument(
        '--uid',
        metavar='UID',
        type=int,
        default=42
    )
    logging.basicConfig(
        level=logging.INFO
    )
    args = parser.parse_args()
    init_user(Connector(args.dsn).connect(), args.uid)

if __name__ == '__main__':
    main()
