#include <macs_pg/macs_pg.h>
#include <boost/format.hpp>
#include <list>
#include <boost/program_options.hpp>
#include "service/get_macs_service.h"
#include "service/options.h"
#include "service/formatter.h"

struct LabelsCompare{
    bool operator()(const macs::Label &a, const macs::Label &b)
    {
        if (a.type() != b.type()) {
            return a.type().code() >= b.type().code();
        }
        return a.symbolicName().code() >= b.symbolicName().code();
    }
};

using namespace macs::pg::utils;

int main(int argc, char **argv) {
    std::string uid, dsn;

    const auto err = parse(argc, argv).as(Uid(uid), Dsn(dsn));
    if (err) {
        std::cerr << err.message() << std::endl;
        return -1;
    }

    macs::ServicePtr service(getMacsService(uid, dsn));

    typedef std::list<macs::Label> LabelsList;

    macs::LabelSet labels_set = service->labels().getAllLabels();

    LabelsList labels;
    for (macs::LabelSet::const_iterator it = labels_set.begin(); it!=labels_set.end(); ++it) {
        labels.push_back(it->second);
    }
    labels.sort(LabelsCompare());

    const std::string fmtString = makeFormatStr(
        {"Lid", "Type", "SymbolicName",
         "MessageCount", "IsUser", "IsSystem",
         "Color", "Revision", "Name"}
    );
    for (LabelsList::iterator lbl = labels.begin(); lbl!=labels.end(); ++lbl) {
        std::cout << boost::format(fmtString)
            % lbl->lid()
            % lbl->type().title()
            % lbl->symbolicName().title()
            % lbl->messagesCount()
            % lbl->isUser()
            % lbl->isSystem()
            % lbl->color()
            % lbl->revision()
            % lbl->name();
    }
    return 0;
}
