#include <iostream>

#include "service/params.h"
#include "service/options.h"
#include "service/get_macs_service.h"

using namespace macs::pg::utils;

namespace {

std::ostream & operator << ( std::ostream & s,  const macs::Change & v ) {
    s << "- Uid: " << v.uid()
      << "\n  Revision: "<< v.revision()
      << "\n  Type: " << v.type()
      << "\n  Changed: " << (v.changed() ? *(v.changed()) : "null")
      << "\n  Arguments: " << (v.arguments() ? *(v.arguments()) : "null");
    return s;
}

}


int main(int argc, char **argv) {
    std::string uid, dsn;
    int64_t changeId;

    const auto err = parse(argc, argv).as(Dsn(dsn),
                                          ChangeId(changeId));

    if (err) {
        std::cerr << err.message() << std::endl;
        return -1;
    }

    const auto service = getShard("42", dsn);
    std::cout << "# GetChange ById: " << changeId << std::endl;

    auto handler = [](const macs::error_code& ec, auto changes) {
        if (ec) {
            std::cerr << "Error:" << ec.what() << std::endl;
        }
        else {
            if (changes.size()) {
                for (const auto& c: changes) {
                    std::cout << c << std::endl;
                }
            }
            else {
                std::cout << "# There are no change with this id" << std::endl;
            }
        }
    };

    macs::error_code ec;
    auto change = service->changeLog().getChanges({changeId}, macs::io::use_sync[ec]);
    handler(ec, std::move(change));

    return 0;
}