#include "envelopes_query_helper.h"
#include "sort_envelopes_helper.h"
#include "service/options.h"

using namespace macs::pg::utils;
using boost::algorithm::join;

int main(int argc, char **argv) {
    std::string uid, dsn, mid, fid, lid, sort;
    std::vector<std::string> midsVector, fidsVector, lidsVector;
    bool onlyNew, withAttaches;

    const auto err = parse(argc, argv).as(Uid(uid), Dsn(dsn),
                                          Mids(midsVector).notNecessarily(),
                                          Fids(fidsVector).notNecessarily(),
                                          Lids(lidsVector).notNecessarily(),
                                          OnlyNew(onlyNew),
                                          WithAttaches(withAttaches),
                                          Sort(sort));
    if (err) {
        std::cerr << err.message() << std::endl;
        return -1;
    }

    const std::list<std::string> mids(midsVector.begin(), midsVector.end());
    const std::list<std::string> fids(fidsVector.begin(), fidsVector.end());
    const std::list<std::string> lids(lidsVector.begin(), lidsVector.end());

    std::cout << "Filter mails with ids=" << join(mids, ", ")
            << " for uid=" << uid << std::endl;

    const auto service = getMacsService(uid, dsn);
    macs::EnvelopesQueryFilterSearch query = service->envelopes().query().filterSearch().
            mids(mids).fids(fids).lids(lids).
            onlyUnread(onlyNew).onlyAtta(withAttaches).sortBy(defineEnvelopesSorting(sort));
    executeQuery("MailboxListFilterSearch", query);

    return 0;
}
