#include <boost/lexical_cast.hpp>
#include <boost/algorithm/string/join.hpp>
#include <boost/range/algorithm/copy.hpp>
#include <macs_pg/macs_pg.h>

#include "envelopes_query_helper.h"
#include "service/get_macs_service.h"
#include "sort_envelopes_helper.h"
#include "service/options.h"

using namespace macs::pg::utils;

int main(int argc, char **argv) {
    std::string uid, dsn, sort;
    std::vector<std::string> fids;
    int from, count;
    bool onw, thv;

    const auto err = parse(argc, argv).as(Uid(uid), Dsn(dsn), Fids(fids),
                                    From(from).def(defaultFrom),
                                    Count(count).def(defaultCount),
                                    OnlyNew(onw), ThreadsView(thv),
                                    Sort(sort));

    if (err) {
        std::cerr << err.message() << std::endl;
        return -1;
    }

    std::cout << "# **** Execute custom MailboxListFolders request for UID=" << uid << std::endl;
    macs::FidList fidList(fids.begin(), fids.end());

    macs::ServicePtr service = getMacsService(uid, dsn);
    macs::EnvelopesQueryInFolder query = service->envelopes().query().inFolders( fidList )
        .from(from).count(count).withinInterval(0, std::time(nullptr))
        .sortBy(defineEnvelopesSorting(sort));

    const std::string fidsStr = std::string("[") + boost::join( fids, ", " ) + std::string("]");

    if (onw) {
        const auto & lbl(service->labels().getLabelBySymbol(macs::Label::Symbol::seen_label));
        executeQuery("MailboxListOnlyNew for fids=" + fidsStr, query.withoutLabel(lbl));
    } else if (thv) {
        executeQuery("ThreadsView for fids=" + fidsStr, query.groupByThreads());
    } else {
        executeQuery("MailboxList for fids=" + fidsStr, query);
    }

    return 0;
}
