#include <service/get_macs_service.h>
#include <service/options.h>
#include "envelopes_query_helper.h"

using namespace macs::pg::utils;

int main(int argc, char **argv) {
    std::string uid, dsn, mid, msgId;
    const auto err = parse(argc, argv).as(
        Uid(uid), Dsn(dsn), Mid(mid).notNecessarily(), MsgId(msgId));
    if (err) {
        std::cerr << err.message() << std::endl;
        return -1;
    }
    const auto service = getMacsService(uid, dsn);

    auto query = service->envelopes().query().inReplyTo();
    if (!mid.empty()) {
        query.mid(mid);
    } else if (!msgId.empty()) {
        query.msgId(msgId);
    } else {
        std::cerr << "Error: msg_id or mid parameter must be set" << std::endl;
        return -1;
    }
    std::cout << "Select replies for mail with msg_id=" << msgId
              << " mid=" << mid
              << " for uid=" << uid << std::endl;

    executeQuery("MailboxListInReplyTo", query);
    return 0;
}
