#include "envelopes_query_helper.h"
#include "sort_envelopes_helper.h"
#include "service/options.h"

using namespace macs::pg::utils;

int main(int argc, char **argv) {
    std::string uid, dsn, mid, lid, sort;
    int from, count;
    bool onw = false;
    bool att = false;

    const auto err = parse(argc, argv).as(Uid(uid), Dsn(dsn),
                                          Mid(mid).notNecessarily(),
                                          Lid(lid).notNecessarily(),
                                          From(from).def(defaultFrom),
                                          Count(count).def(defaultCount),
                                          OnlyNew(onw),
                                          WithAttaches(att),
                                          Sort(sort));

    if (err) {
        std::cerr << err.message() << std::endl;
        return -1;
    }

    std::cout << "# ***** Execute custom MailboxList request for UID=" << uid << std::endl;

    macs::ServicePtr service = getMacsService(uid, dsn);
    macs::EnvelopesQueryInMailbox query = service->envelopes().query().inMailbox().
            from(from).count(count)
            .sortBy(defineEnvelopesSorting(sort));

    if (att) {
        const auto & lbl(service->labels().getLabelBySymbol(macs::Label::Symbol::attached_label));
        executeQuery("MailboxListAllWithFakeLabel", query.withLabel(lbl));
    } else if (onw) {
        const auto & lbl(service->labels().getLabelBySymbol(macs::Label::Symbol::seen_label));
        executeQuery("MailboxListOnlyNew", query.withoutLabel(lbl));
    } else if (!lid.empty()) {
        executeQuery("MailboxListLabel for lid=" + lid, query.withLabel(getLabel(lid)));
    } else if (!mid.empty()) {
        executeQuery("MailboxListNearest for mid=" + mid, query.fromMid(mid));
    } else  {
        executeQuery("MailboxListAll", query);
    }

    return 0;
}
