#include <iostream>

#include "service/params.h"
#include "service/options.h"
#include "service/get_macs_service.h"
#include "subscription_io.h"

using namespace macs::pg::utils;


int main(int argc, char **argv) {
    std::string dsn;
    std::string workerId;
    std::string uid;
    std::int64_t subscriptionId = 0;

    const auto err = parse(argc, argv).as(Dsn(dsn), Uid(uid).notNecessarily(),
                                          SubscriptionId(subscriptionId).notNecessarily(),
                                          WorkerId(workerId).notNecessarily());

    if (err) {
        std::cerr << err.message() << std::endl;
        return -1;
    }

    if ( workerId.empty() && (subscriptionId == 0 || uid.empty()) ) {
        std::cerr << "specify worker_id or (subscription_id and uid) " << std::endl;
        return -1;
    }

    const auto service = getShard("42", dsn);

    macs::error_code ec;
    if (!workerId.empty()) {
        std::cout << "# GetSubscriptionsByWorkerId " << workerId << std::endl;
        OnSubscriptionsChunk handler;
        auto data = service->subscriptions().getByWorker(workerId, macs::io::use_sync[ec]);
        handler(ec, data);
    } else {
        std::cout << "# GetSubscriptionById uid: " << uid << ", subscriptionId: " << subscriptionId << std::endl;
        OnSubscription handler;
        auto data = service->subscriptions().getById(uid, subscriptionId, macs::io::use_sync[ec]);
        handler(ec, data);
    }

    return 0;
}