#include "envelopes_query_helper.h"
#include "sort_envelopes_helper.h"
#include "service/options.h"

using namespace macs::pg::utils;

int main(int argc, char **argv) {
    std::string uid, dsn, tid, mid, sort;
    std::string withLid, withoutLid;
    int from, count;

    const auto err = parse(argc, argv).as(Uid(uid), Dsn(dsn), Tid(tid),
                                          Mid(mid).notNecessarily(),
                                          From(from).def(defaultFrom),
                                          Count(count).def(defaultCount),
                                          WithLid(withLid), WithoutLid(withoutLid),
                                          Sort(sort));
    if (err) {
        std::cerr << err.message() << std::endl;
        return -1;
    }

    std::cout << "****** Execute custom Thread request for UID=" << uid << ", tid=" << tid << std::endl;

    macs::ServicePtr service = getMacsService(uid, dsn);
    macs::EnvelopesQueryInThread query = service->envelopes().query().inThread(tid).
            from(from).count(count).sortBy(defineEnvelopesSorting(sort));

    if (!mid.empty()) {
        executeQuery("MailboxListNearestInThread for mid=" + mid, query.from(mid));
    } else if (!withLid.empty()) {
        executeQuery("MailboxListInThreadWithLabel for lid=" + withLid, query.withLabel(getLabel(withLid)));
    } else if (!withoutLid.empty()) {
        executeQuery("MailboxListInThreadWithoutLabel for lid=" + withoutLid, query.withoutLabel(getLabel(withoutLid)));
    } else {
        executeQuery("MailboxListThread", query);
    }

    return 0;
}
