#include "envelopes_query_helper.h"
#include "service/options.h"

using namespace macs::pg::utils;

int main(int argc, char **argv) {
    std::string uid, dsn, msgId;

    const auto err = parse(argc, argv).as(Uid(uid), Dsn(dsn), MsgId(msgId).must());
    if (err) {
        std::cerr << err.message() << std::endl;
        return -1;
    }

    std::cout << "# List not-answered mails with msgId= " << msgId << " for uid=" << uid << std::endl;

    const auto service = getMacsService(uid, dsn);
    const auto lbl = service->labels().getOrCreateLabel(macs::Label::Symbol::remindNoAnswer_label);
    auto query = service->envelopes().query().withNoAnswer().msgId(msgId).includeLabel(lbl.lid());
    executeQuery("MailboxListByMsgIdWithLabel", query);

    return 0;
}
