#include <future>
#include <macs_pg/macs_pg.h>

#include <service/get_macs_service.h>
#include <service/options.h>

using namespace macs::pg::utils;

int main(int argc, char **argv) {
    std::string uid, dsn;
    const auto err = parse(argc, argv).as(Uid(uid), Dsn(dsn));
    if (err) {
        std::cerr << err.message() << std::endl;
        return -1;
    }

    std::cout << "****** Get mailbox revision for UID=" << uid << std::endl;
    macs::ServicePtr service = getMacsService(uid, dsn);

    try {
        std::promise<void> result;
        auto f = result.get_future();
        service->folders().getMailboxRevision([&result] (const macs::error_code& ec, macs::Revision r) {
            auto p = std::move(result);
            if (ec) {
                mail_errors::setRuntimeError(p, ec);
            } else {
                std::cout << "Mailbox revision: " << r << std::endl;
                p.set_value();
            }
        });

        f.get();
    } catch (const std::exception& e) {
        std::cerr << e.what() << std::endl;
    }


    return 0;
}
