#include <future>

#include "service/get_macs_service.h"
#include "service/options.h"

#include <macs_pg/mailish/repository.h>

using namespace macs::pg::utils;

int main(int argc, char **argv) {
    std::string uid, dsn, fid;
    std::vector<uint64_t> imapIds;

    const auto err = parse(argc, argv).as(Uid(uid), Dsn(dsn), Fid(fid), ImapIds(imapIds));

    if (err) {
        std::cerr << err.message() << std::endl;
        return -1;
    }

    const auto service = getMacsService(uid, dsn);

    std::cout << "# Delete mailish messages" << std::endl;

    try {
        service->mailish().deleteMailishEntries(fid, imapIds);
        std::cout << "# Ok" << std::endl;
    } catch (const std::exception& e) {
        std::cerr << "# Exception: " << e.what() << std::endl;
    }

    std::cout << "# Complete" << std::endl;

    return 0;
}
